
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1172.C - Message 1172 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1172 messages.
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <share.h>
#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1172 message from the ZMsgBuf.
//
void Dec1172(tMSGBUF *ZMsgBuf, tMSG1172 *Msg)
{                                            
   // perform special decoding to unpack words
   GetBit(&Bits1170.DRHeadingRateValid,            ZMsgBuf, 9, 0);  // 1=true
   GetBit(&Bits1170.DRHeadingRateSensorTempValid , ZMsgBuf, 9, 1);  // 1=true

}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1172 message in the ZMsgBuf. 
//
void Bld1172(tMSGBUF *ZMsgBuf, tMSG1172 *Msg)
{

}                                            

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1172 message from the ZMsgBuf.
//
void Show1172(tMSG1172 *Msg)
{
   char    Buf[80] = "";
   char    DRValidity[3];        

   // dr validity flags  
   strcpy(DRValidity, "  ");
   if(Bits1170.DRHeadingRateValid            ) DRValidity[0] = 'R';
   if(Bits1170.DRHeadingRateSensorTempValid  ) DRValidity[1] = 'T';

   // output the data items   
   sprintf(Buf,"%05d"     ,Msg->SequenceNumber                );ShowText(Buf,TIMR+ 6,TIMC+ 4);
   sprintf(Buf,"%3s"      ,DRValidity                         );ShowText(Buf,DRFR   ,DRFC+ 4);
   sprintf(Buf,"%05.02f"  ,Msg->DRHeadingRate/100.0           );ShowText(Buf,DRFR+ 1,DRFC+ 5);
   sprintf(Buf,"%05.02f"  ,Msg->DRHeadingRateSensorTemp/100.0 );ShowText(Buf,DRFR+ 2,DRFC+ 5);
}                                                   
                                      
                                           
